#pragma once

#include "gmplugin.h"

// First position in the Tokenizer string contains the full string, so use [1] instead of [0]
// for the first string

class Tokenizer 
{
private:
	DynamicVectorClass<StringClass> Tokens;
	int VectorSize;
	void Build(const StringClass &Text, int Pos);

public:
	Tokenizer();
	Tokenizer(const Tokenizer &Copy);
	Tokenizer(const StringClass &Text, int Pos = 0);
	Tokenizer& operator=(const Tokenizer &Copy);
	Tokenizer& operator=(const StringClass &Text);
	StringClass operator[](int Pos); 
	StringClass operator()(int Start, int End = 0);
	int Size();
	void Erase(int Pos);
	void Replace(int Pos,const StringClass &Rep);
//	void Erase_Global(int Pos);
	void Add(const StringClass &Text, int Pos = 0);
}; 